/**
  Copyright (c) 2010 Freescale Semiconductor
  
  \file  	  DCU.h
  \brief	  This is the DCU Driver File
  \brief	  Configures Freq. and Activates DCU and layers on MPC56xxS
  \author	  Freescale Semiconductor
  \author	  Automotive Systems Solutions Engineering
  \author	  IM, b06623
  \version	  2.0
  \revision	  $Revision: 275 $
  \date  	  $Date: 2011-11-16 15:44:23 -0600 (Wed, 16 Nov 2011) $
  
  * History:  10/July/2008 - Initial Version (IM)
              13/May/2009 - MISRA Check (IM)
              March-2010  -	Support to Sharp LQ070 (IM)
              April-2010  - Initial Upgrade to formally support DCU3 (IM)
              21Sept2010 - DCU and DCULITE can have different displays. Also, deprecated DCU_Plane_t  

* Copyright (c) 2010, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
  
*/

 
#ifndef 	_DCU_H_
#define  	_DCU_H_     

#include "Common.h"
#include "DCU.h"

/* Data Types */

typedef  enum
{
    DCU_VSYNC,
    DCU_VBLANK,
    DCU_LSBFVS,
    DCU_UNKNOWN
}DCU_Timing_t;

/* DEPRECATED, will be removed in future releases */
#ifndef REMOVE_DEPRECATED
typedef  enum
{
	DCU_PLANE0 = 0,
	DCU_PLANE1,
	DCU_PLANE2,
	DCU_PLANE3,
	DCU_PLANE4,
	DCU_PLANE5,
	DCU_PLANE6,
	DCU_PLANE7,
	DCU_PLANE8,
	DCU_PLANE9,
	DCU_PLANE10,
	DCU_PLANE11,
	DCU_PLANE12,
	DCU_PLANE13,
	DCU_PLANE14,
	DCU_PLANE15
} DCU_Plane_t;
#endif

#define DCU_DCU				(0u)
#define DCU_DCULITE			(1u)

#define DCU_CHROMMA_ON		(1u)
#define DCU_CHROMMA_OFF		(0u)

#define DCU_ALPHA_OFF		(0u)
#define DCU_ALPHACHROMMA_ON	(1u)
#define DCU_ALPHAALL_ON		(2u)

typedef  void  (*DCU_CallbackType)(void);

/* Configuration Parameters */
#ifndef	DCU_LCD
//#define	DCU_LCD	DCU_SHARP_LQ043
#define DCU_LCD DVI_XGA
#endif

#ifndef	DCULITE_LCD
#define	DCULITE_LCD	DCU_SHARP_LQ043
#endif

/* Don't modify the following macros */
#define     DCU_WIDTH_ATOMICITY     (1)
#define     DCU_WIDTH_ATOMICITY2    (16)
#define		DCUCTX					(*DCU_PTR)
#define 	DCU_DCUMAXLAYERS		(64)

#ifdef DCULITE
#define 	DCU_DCULITEMAXLAYERS	(4)
#endif
#define 	DCU_MAXLAYERS			(16)

/* Public Functions */
void DCU_SelectDCU(uint8_t device);
uint8_t DCU_GetCurrentDCU(void);
void DCU_Init(uint32_t freq);
void DCU_SetChroma(uint8_t layer, uint32_t max, uint32_t min);
void DCU_SetCallbackVSBLANK(DCU_CallbackType Callback);
void DCU_SetCallbackLSBFVS(DCU_CallbackType Callback);
void DCU_SetCallbackVSYNC(DCU_CallbackType Callback);
void DCU_SetCallbackProgDone(DCU_CallbackType Callback);
void DCU_drvInit(void);
void DCU0_init(uint32_t freq, uint8_t mode);
void DCU1_init(uint32_t freq, uint8_t mode);

/* Public Macros Function-alike */		


#define  	DCU_LayerEnable( Layer )	  	DCUCTX.LAYER [ ( Layer ) ].CTRLDESCL4.B.EN = 1u 
#define  	DCU_LayerDisable( Layer )	  	DCUCTX.LAYER [ ( Layer ) ].CTRLDESCL4.B.EN = 0u
#define  	DCU_LayerIsEnabled( Layer )	  	(DCUCTX.LAYER [ ( Layer ) ].CTRLDESCL4.B.EN) 
#define  	DCU_LayerAddress( Layer )	  	(DCUCTX.LAYER [ ( Layer ) ].CTRLDESCL3.R)

#define 	DCU_LayerSetWidth( Layer, Width )	DCUCTX.LAYER[ (Layer) ].CTRLDESCL1.B.WIDTH = ((Width)/DCU_WIDTH_ATOMICITY)
#define 	DCU_LayerGetWidth( Layer )		(DCUCTX.LAYER[ (Layer) ].CTRLDESCL1.B.WIDTH*DCU_WIDTH_ATOMICITY)
#define 	DCU_LayerSetHeight( Layer, Height )	DCUCTX.LAYER[ (Layer) ].CTRLDESCL1.B.HEIGHT = (Height)
#define 	DCU_LayerGetHeight( Layer )		(DCUCTX.LAYER[ (Layer) ].CTRLDESCL1.B.HEIGHT)

#define 	DCU_LayerSetX( Layer, X )		DCUCTX.LAYER[ (Layer) ].CTRLDESCL2.B.POSX = ((X)/DCU_WIDTH_ATOMICITY)
#define 	DCU_LayerGetX( Layer )			(DCUCTX.LAYER[ (Layer) ].CTRLDESCL2.B.POSX*DCU_WIDTH_ATOMICITY)
#define 	DCU_LayerSetY( Layer, Y )		DCUCTX.LAYER[ (Layer) ].CTRLDESCL2.B.POSY  = (Y)
#define 	DCU_LayerGetY( Layer )			(DCUCTX.LAYER[ (Layer) ].CTRLDESCL2.B.POSY) 

#define 	DCU_LayerBPP( Layer )			(DCUCTX.LAYER[ (Layer) ].CTRLDESCL4.B.BPP)
#define 	DCU_LayerAlpha( Layer )			(DCUCTX.LAYER[ (Layer) ].CTRLDESCL4.B.TRANS)
#define		DCU_LayerOffset( Layer )		(DCUCTX.LAYER[ (Layer) ].CTRLDESCL4.B.LUOFFS)
#define		DCU_LayerAlphaCfg( Layer )		(DCUCTX.LAYER[ (Layer) ].CTRLDESCL4.B.AB)
#define		DCU_LayerChromaCfg( Layer )		(DCUCTX.LAYER[ (Layer) ].CTRLDESCL4.B.BB)

#define 	DCU_GetMaxY( )					(DCUCTX.DSPSIZE.B.DELTAY)			
#define 	DCU_GetMaxX( )					(DCUCTX.DSPSIZE.B.DELTAX*DCU_WIDTH_ATOMICITY2)
#define		DCU_Clut( idx )					(DCUCTX.CLUT[ (idx) ])
#define		DCU_SetLinesBeforVSYNC( Lines )	(DCUCTX.THRESHOLD.B.LS_BF_VS =(Lines))
#define		DCU_GetTimingStatus( )			(*DCU_TimingStatus_p)

#define		DCU_TileMode(Layer, OnOff, Width, Height)	DCUCTX.LAYER [ ( Layer ) ].CTRLDESCL4.B.TILE_EN = (OnOff);\
														DCUCTX.LAYER [ ( Layer ) ].CTRLDESCL7.B.TILE_VER_SIZE = (Height);\
														DCUCTX.LAYER [ ( Layer ) ].CTRLDESCL7.B.TILE_HOR_SIZE = ((Width)/DCU_WIDTH_ATOMICITY2)
														


#define		DCU_RLE(Layer,OnOff, size)			DCUCTX.COMP_IMSIZE.B.SIZE = (size); \
												DCUCTX.LAYER [ ( Layer ) ].CTRLDESCL4.B.RLE_EN = (OnOff)										  


#define 	DCU_HWCursorHeight( )				(DCUCTX.CTRLDESCCURSOR1.B.HEIGHT)
#define 	DCU_HWCursorWidth( )				(DCUCTX.CTRLDESCCURSOR1.B.WIDTH)
#define 	DCU_HWCursorX( )					(DCUCTX.CTRLDESCCURSOR2.B.POSX)
#define 	DCU_HWCursorY( )					(DCUCTX.CTRLDESCCURSOR2.B.POSY)
#define 	DCU_HWCursorDisable( )				DCUCTX.CTRLDESCCURSOR3.B.CUR_EN = 0u
#define 	DCU_HWCursorEnable( )				DCUCTX.CTRLDESCCURSOR3.B.CUR_EN = 1u
#define 	DCU_HWCursorSetColor( value )		DCUCTX.CTRLDESCCURSOR3.B.CURSOR_DEFAULT_COLOR = (value)
#define 	DCU_HWCursorBlinkEn( )				DCUCTX.CTRLDESCCURSOR4.B.EN_BLINK = 1u
#define 	DCU_HWCursorBlinkDis( )				DCUCTX.CTRLDESCCURSOR4.B.EN_BLINK = 0u
#define 	DCU_HWCursorSetBlinkONVal( value )	DCUCTX.CTRLDESCCURSOR4.B.HWC_BLINK_ON = (value)
#define 	DCU_HWCursorSetBlinkOFFVal( value )	DCUCTX.CTRLDESCCURSOR4.B.HWC_BLINK_OFF = (value)
#define		DCU_Cursor( idx )					(DCUCTX.CURSOR[ (idx) ])

#define		DCU_ForeGroundColor( Layer )		(DCUCTX.LAYER[Layer].CTRLDESCL8.B.FG_FCOLOR)				
#define		DCU_BackGroundColor( Layer )		(DCUCTX.LAYER[Layer].CTRLDESCL9.B.FG_BCOLOR)

#define		DCU_BackGround(color)				DCUCTX.BGND.R = (color)
#define  	DCU_Enable( )		          		DCUCTX.DCU_MODE.B.DCU_MODE = 1u

/* End of user modifiable parameters */


/********************** Private Data, DO NOT MODIFY ***************************************************************/

#define  	DCU_HITACHI_TX09			   0
#define  	DCU_SHARP_LQ043  			   1
#define  	DCU_SHARP_LQ070				   2
#define  	DVI_XGA					   3
#define  	DVI_SVGA				   4
#define		T55382GD050				   5
 	

extern uint8_t	DCU_MaxLayersCTX;
extern DCU_Timing_t*	DCU_TimingStatus_p;
extern volatile struct DCUx_tag	* DCU_PTR;
void DCU_TIMING_ISR(void);
void DCULITE_TIMING_ISR(void);

#endif
